<?php

/* @var $this yii\web\View */

use yii\helpers\Html;
use yii\helpers\Url;
use backend\models\Tercero;
use backend\models\User;

$this->title = $model->titulo;
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("

/* FILE MANAGER */

.mail-attachment{
  padding-top:20px;
}

.mail-attachment h5{
  font-size:16px;
}

.file-box {
  float: left;
  width: 160px;
}
.file-manager h5 {
  text-transform: uppercase;
}
.file-manager {
  list-style: none outside none;
  margin: 0;
  padding: 0;
}
.folder-list li a {
  color: #666666;
  display: block;
  padding: 5px 0;
}
.folder-list li {
  border-bottom: 1px solid #e7eaec;
  display: block;
}
.folder-list li i {
  margin-right: 8px;
  color: #3d4d5d;
}
.category-list li a {
  color: #666666;
  display: block;
  padding: 5px 0;
}
.category-list li {
  display: block;
}
.category-list li i {
  margin-right: 8px;
  color: #3d4d5d;
}
.category-list li a .text-navy {
  color: #1ab394;
}
.category-list li a .text-primary {
  color: #1c84c6;
}
.category-list li a .text-info {
  color: #23c6c8;
}
.category-list li a .text-danger {
  color: #cb0606;
}
.category-list li a .text-warning {
  color: #F8AC59;
}
.file-manager h5.tag-title {
  margin-top: 20px;
}
.tag-list li {
  float: left;
}
.tag-list li a {
  font-size: 10px;
  background-color: #f3f3f4;
  padding: 5px 12px;
  color: inherit;
  border-radius: 2px;
  border: 1px solid #e7eaec;
  margin-right: 5px;
  margin-top: 5px;
  display: block;
}
.file {
  border: 1px solid #e7eaec;
  padding: 0;
  background-color: #ffffff;
  position: relative;
  margin-bottom: 20px;
  margin-right: 20px;
}
.file-manager .hr-line-dashed {
  margin: 15px 0;
}

.file .adjunto {
  height: 100px;
  overflow: hidden;
}

.file > a .icon,
.file img {
  width: 100%;
}

.file .icon {
  padding: 15px 10px;
  text-align: center;
}
.file-control {
  color: inherit;
  font-size: 11px;
  margin-right: 10px;
}
.file-control.active {
  text-decoration: underline;
}
.file .icon i {
  font-size: 70px;
  color: #dadada;
}
.file .file-name {
  padding: 10px;
  background-color: #f8f8f8;
  border-top: 1px solid #e7eaec;
  display: inline-block;
  width: 100%;

}
.file-name small {
  color: #676a6c;
}
.corner {
  position: absolute;
  display: inline-block;
  width: 0;
  height: 0;
  line-height: 0;
  border: 0.6em solid transparent;
  border-right: 0.6em solid #f1f1f1;
  border-bottom: 0.6em solid #f1f1f1;
  right: 0em;
  bottom: 0em;
}

  ");
?>

<section class="ftco-section">
      <div class="container">
        <div class="row">
          <div class="col-lg-8 ftco-animate">
            <h3 class="heading"><?= $model->titulo ?></h3>

            <div class="meta" style="padding-bottom: 20px;">
                <a href="<?= Url::to(['site/blog', 'categoria' => $model->categoria]) ?>">
                  <span class="icon-tag text-info"></span> 
                    <?= $model->categorias->categoria ?>
                </a>
                  &nbsp;&nbsp;&nbsp;

                <span class="icon-calendar text-info"></span> 
                  <?= Yii::$app->formatter->asDate($model->creado_el, 'long');?>
                  &nbsp;&nbsp;&nbsp;
                  <!--
                <span class="icon-person text-info"></span> 
                  <? 
                      
                      if($model->creado_por == 1)
                      {
                          echo "Sonic";
                      }
                      else
                      {
                          $user = User::find()->where(['id' => $model->creado_por])->one();
                          $tercero = Tercero::find()->where(['identificacion' => $user->username])->one();  
                          echo $tercero->nombre;
                      }  
                      
                  ?>
                  &nbsp;&nbsp;&nbsp;-->
                <span class="icon-eye text-info"></span> <?= $model->visto ?>
            </div>

            <?= $model->introduccion ?>
            
            <?
                if($model->imagen)
                { 
            ?>     
                  <p>
                    <img src="<?= Yii::$app->homeUrl ?>admin/uploads/blog/lg-<?= $model->imagen ?>" alt="" class="img-fluid">
                  </p>
            <?
                }
            ?>      
            <?= $model->contenido ?>


            <?php 
                if ($model->adjuntos != '') 
                {
                    $adjuntos = explode(',', $model->adjuntos); 
                    $adjuntos_cantidad = count($adjuntos);

            ?>

            <div class="mail-attachment"><!-- INICIO ATTACH -->
                
                <h5>
                    <span class="icon-attach_file"></span> <?=  ($adjuntos_cantidad > '1') ? $adjuntos_cantidad.' Archivos Adjuntos' : $adjuntos_cantidad.' Archivo Adjunto'?></span>
                </h5>


                <div class="attachment">
                    
                    <?php 
                        foreach ($adjuntos as $adjunto) { 
                            $archivo = unserialize($adjunto);
                    ?>
                        

                        <div class="file-box">
                            <div class="file">
                                
                                <a href="https://drive.google.com/open?id=<?= $archivo['id']?>" target="_blank">
                                    <span class="corner"></span>

                                    <?
                                        echo "<div class='adjunto'>";
                                        echo Html::img('https://drive.google.com/thumbnail?id='.$archivo["id"], ['alt'=>$archivo["file"], 'class'=>'']);
                                        echo"</div>";
                                    ?>
                                    
                                    <div class="file-name">
                                        <?= $archivo["file"] ?>
                                    </div>
                                </a>
                            </div>

                        </div>
                    <?php

                        }
                    ?>    
                    
                    <div class="clearfix"></div>
                </div> 

            </div><!-- FIN ATTACH -->

            <?php } ?>


          </div> <!-- .col-md-8 -->

          <div class="col-lg-4 sidebar ftco-animate">
            <div class="sidebar-box">
              <form action="#" class="search-form">
                <div class="form-group">
                  <span class="icon icon-search"></span>
                  <input type="text" class="form-control" placeholder="Buscar...">
                </div>
              </form>
            </div>
            <div class="sidebar-box ftco-animate">
              <h3>Categorías</h3>
              <ul class="categories">
                <?php
                    foreach ($categorias as $categoria) {
                      echo "<li>".html::a($categoria->categoria,['site/blog','categoria' => $categoria->id])."</li>";
                    }
                ?>
              </ul>
            </div>

            <div class="sidebar-box ftco-animate">
              <h3>Artículos Populares</h3>

              <?php
                    foreach ($populares as $popular) {  

                      if($popular->imagen != '')
                      {
                        $imagen = Yii::$app->homeUrl."admin/uploads/blog/sm-".$popular->imagen;
                      }
                      else
                      {
                        $imagen = Yii::$app->homeUrl."admin/images/sonic_sm_blog.png";
                      } 
                      
              ?>

              <div class="block-21 mb-4 d-flex">
                <a href="<?= Url::to(['site/view', 'id' => $popular->id]) ?>" class="blog-img mr-4" style="background-image: url(<?= $imagen ?>);"></a>
                <div class="text">
                  <h3 class="heading" style="margin-top: 0px !important; margin-bottom: 0px !important; padding-bottom: 0px !important;">
                    <a href="<?= Url::to(['site/view', 'id' => $popular->id]) ?>"><?= $popular->titulo ?></a></h3>
                  <div class="meta" style="padding-bottom: 20px;">
                    <a href="<?= Url::to(['site/blog', 'categoria' => $popular->categoria]) ?>">
                      <span class="icon-tag text-info"></span> 
                        <?= $popular->categorias->categoria ?>
                    </a>
                        
                    &nbsp;&nbsp;&nbsp;
                    <span class="icon-calendar text-success"></span> 
                      <?= Yii::$app->formatter->asDate($model->creado_el, 'short');?>
                      
                  </div>
                </div>
              </div>

              <?php } ?>

            </div>

          <!--
            <div class="sidebar-box ftco-animate">
              <h3>Paragraph</h3>
              <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ducimus itaque, autem necessitatibus voluptate quod mollitia delectus aut, sunt placeat nam vero culpa sapiente consectetur similique, inventore eos fugit cupiditate numquam!</p>
            </div>
          -->            

          </div><!-- END COL -->
        </div>
      </div>
    </section>